/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model.panel;

import DE.siemens.ad.logo.dialog.comp.BlockListCellRenderer;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.MathDetectionParameter;
import DE.siemens.ad.logo.model.Parameter;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogMathsBlock;
import DE.siemens.ad.logo.model.panel.AbstractProtectionPanel;
import DE.siemens.ad.logo.util.Language;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class MathDetectionPanel
extends AbstractProtectionPanel {
    private static final long serialVersionUID = 1L;
    private JLabel flblReferencedMathFB = null;
    private JComboBox fReferenceList = null;
    private JLabel flblErrorToDetect = null;
    private JRadioButton fOptionZeroDivision = null;
    private JRadioButton fOptionOverflow = null;
    private JRadioButton fOptionBoth = null;
    private JCheckBox fcbAutoRstMode = null;
    protected WiringDiagram fWiringDiagram;

    public MathDetectionPanel() {
    }

    public MathDetectionPanel(Vector panels, Parameter parameterReference, boolean simulationMode) {
        super(panels, parameterReference, simulationMode);
        this.fWiringDiagram = ((BlockParameter)parameterReference).getBlock().getWiringDiagram();
        this.initComponents();
    }

    private void initComponents() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 0));
        this.addParameterPane(panel);
        GridBagConstraints gbc = null;
        this.flblReferencedMathFB = new JLabel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        panel.add((Component)this.flblReferencedMathFB, gbc);
        this.fReferenceList = new JComboBox();
        BlockListCellRenderer renderer = new BlockListCellRenderer(true);
        renderer.setScale(0.7f);
        this.fReferenceList.setRenderer(renderer);
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets.set(0, 0, 0, 10);
        panel.add((Component)this.fReferenceList, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        panel.add((Component)new JLabel(), gbc);
        this.flblErrorToDetect = new JLabel();
        this.flblErrorToDetect.setAlignmentY(0.0f);
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.gridy = 1;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets.set(10, 0, 0, 0);
        panel.add((Component)this.flblErrorToDetect, gbc);
        this.fOptionZeroDivision = new JRadioButton();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.insets.set(0, 20, 0, 0);
        panel.add((Component)this.fOptionZeroDivision, gbc);
        this.fOptionOverflow = new JRadioButton();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        panel.add((Component)this.fOptionOverflow, gbc);
        this.fOptionBoth = new JRadioButton();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        panel.add((Component)this.fOptionBoth, gbc);
        ButtonGroup bg1 = new ButtonGroup();
        bg1.add(this.fOptionZeroDivision);
        bg1.add(this.fOptionOverflow);
        bg1.add(this.fOptionBoth);
        this.fcbAutoRstMode = new JCheckBox();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 17;
        gbc.weightx = 0.0;
        gbc.weighty = 1.0;
        gbc.insets.set(10, 0, 0, 0);
        panel.add((Component)this.fcbAutoRstMode, gbc);
    }

    public boolean checkChanged() {
        return true;
    }

    public boolean checkFieldContents() {
        return true;
    }

    public void loadFieldContents() {
        super.loadFieldContents();
        MathDetectionParameter param = (MathDetectionParameter)this.fParameterReference;
        Vector blocks = this.getMathBlocks();
        this.fReferenceList.setModel(new DefaultComboBoxModel<Object>(blocks.toArray()));
        this.selectItemInReferenceList(param.getReferencedBlockNumber());
        if (param.isDetectZeroDivision() && param.isDetectOverflow()) {
            this.fOptionBoth.setSelected(true);
        } else if (param.isDetectOverflow()) {
            this.fOptionOverflow.setSelected(param.isDetectOverflow());
        } else {
            this.fOptionZeroDivision.setSelected(true);
        }
        this.fcbAutoRstMode.setSelected(param.isAutoResetMode());
    }

    public void storeFieldContents() {
        super.storeFieldContents();
        MathDetectionParameter param = (MathDetectionParameter)this.fParameterReference;
        param.setReferencedBlockNumber(this.getSelectedBlockNumber());
        param.setDetectZeroDivision(this.fOptionZeroDivision.isSelected() || this.fOptionBoth.isSelected());
        param.setDetectOverflow(this.fOptionOverflow.isSelected() || this.fOptionBoth.isSelected());
        param.setAutoResetMode(this.fcbAutoRstMode.isSelected());
        param.resetErrorStatus();
    }

    private int getSelectedBlockNumber() {
        if (this.fReferenceList.getSelectedIndex() > 0) {
            Block block = (Block)this.fReferenceList.getSelectedItem();
            return block.getNumber();
        }
        return -1;
    }

    public void setLabels() {
        super.setLabels();
        this.flblReferencedMathFB.setText(Language.getString("dialog.parameter.mathDetection.ReferencedMathBN", "Referenced Mathematic Instructions Block:"));
        this.flblErrorToDetect.setText(Language.getString("dialog.parameter.mathDetection.ErrToDetect", "Error to detect:"));
        this.fOptionZeroDivision.setText(Language.getString("dialog.parameter.mathDetection.ZeroDiv", "zero division"));
        this.fOptionOverflow.setText(Language.getString("dialog.parameter.mathDetection.Overflow", "overflow"));
        this.fOptionBoth.setText(Language.getString("dialog.parameter.mathDetection.Both", "Both"));
        this.fcbAutoRstMode.setText(Language.getString("dialog.parameter.mathDetection.autoReset", "Automatically reset"));
    }

    private void selectItemInReferenceList(int blockNumber) {
        if (blockNumber <= 0) {
            this.fReferenceList.setSelectedIndex(0);
            return;
        }
        ComboBoxModel model = this.fReferenceList.getModel();
        int size = model.getSize();
        for (int i = 1; i < size; ++i) {
            Block item = (Block)model.getElementAt(i);
            if (item.getNumber() != blockNumber) continue;
            this.fReferenceList.setSelectedIndex(i);
            return;
        }
        System.err.println("Can not found referenced Math FB");
    }

    private Vector getMathBlocks() {
        Enumeration blocks = this.fWiringDiagram.getBlocks().elements();
        Vector<Object> msgBlocks = new Vector<Object>();
        msgBlocks.add(Language.getString("dialog.parameter.mathDetection.nullBlock", "---- null ----"));
        while (blocks.hasMoreElements()) {
            Block block = (Block)blocks.nextElement();
            if (!(block instanceof AnalogMathsBlock)) continue;
            msgBlocks.add(block);
        }
        return msgBlocks;
    }
}

